<?php
/*
Plugin Name: حمل و نقل محصول
Plugin URI: http://www.karaneshan.ir
Description: اضافه نمودن روشهای ارسال پستی و باربری
Author: Shahin Gharghi
Author URI: http://www.gharghi.ir
Version: 1.0.2
*/


/**
* Check if WooCommerce is active
*/
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
 
//Class for Pishtaz shipping method
	function post_shipping_method_init() {
//=================================================================
//function for sefareshi shipping method
		//check if the class exist before
		if ( ! class_exists( 'WC_Post_Pishtaz_Shipping_Method' ) ) {
			//extending the class using woocommerce shipping class
			class WC_Post_Pishtaz_Shipping_Method extends WC_Shipping_Method  {
				//constructing the class
				public function __construct() {
					$this->id = 'post_pishtaz_shipping_method'; 
					$this->method_title = 'پست پیشتاز';
					$this->method_description = 'ارسال از طریق پست پیشتاز';
					$this->init();
				}
				//initializing the needs of class
				function init() {
					// Load the settings API
					$this->init_form_fields(); 
					$this->init_settings(); 
					// Define user set variables
					$this->enabled 		  = $this->get_option( 'enabled' );
					$this->title 		  = $this->get_option( 'title' );
					$this->cost 		  = $this->get_option( 'cost' );
					$this->calc_method 	  = $this->get_option( 'calc_method' );
					// Save settings in admin if you have any defined
					add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
				} 
				//the function of calculating the additional cost
				public function calculate_shipping( $package ) {
					//getting the weight of each product
					 foreach ( $package['contents'] as $item_id => $item ) {
					  $product = $item['data'];
					  $weight = $product->get_weight();
				  }
				  //check if cost calculation is static 
				  if ($this->get_option('weight_enabled')=='no')
				  {
					   $calculated_cost=$this->get_option( 'cost' );
				  }
				  //check if cost calculation is variable
				 else if ($this->get_option('weight_enabled')=='yes')
				 { 
				  $weight_options=explode(",",$this->get_option('calc_method'));
				  $weight_Array2=array();
				  //getting the list of shipping prices per weight
				  for ($i=0;$i<count($weight_options);$i++)
				  {
					  $weight_Array=explode(':',$weight_options[$i]);
					  $weight_Array2[]= array('weight' => $weight_Array[0], 'price' => $weight_Array[1]);
				  }
				  //choosing the price from weight
				  for ($i=0;$i<count($weight_options)-1;$i++)
				  {
					  if ($weight >= $weight_Array2[$i]['weight']&&$weight < $weight_Array2[$i+1]['weight'])
						  $calculated_cost= $weight_Array2[$i+1]['price'];
				  }		 
				 }
				 //creating the array for adding cost
				  $rate = array(
					'id' => $this->id,
					'label' => $this->title,
					'cost' => $calculated_cost 
					);
					// adding the cost to the main cost
					$this->add_rate( $rate );
				}
				//creating admin form options
				function init_form_fields() {
					global $woocommerce;
					$this->form_fields = array(
						'enabled' => array(
										'title' 		=> __( 'Enable/Disable', 'woocommerce' ),
										'type' 			=> 'checkbox',
										'label' 		=> __( 'Enable this shipping method', 'woocommerce' ),
										'default' 		=> 'no',
									),
						'title' => array(
										'title' 		=> __( 'Method Title', 'woocommerce' ),
										'type' 			=> 'text',
										'description' 	=> __( 'This controls the title which the user sees during checkout.', 'woocommerce' ),
										'default'		=> 'پست پیشتاز'
									),
						'cost' => array(
										'title' 		=> 'هزینه ثابت',
										'type' 			=> 'text',
										'description' 	=> 'تعیین هزینه ثابت برای پست پیشتاز',
										'default'		=> '0'
									),
						'weight_enabled' => array(
										'title' 		=> 'تعرفه متغیر',
										'type' 			=> 'checkbox',
										'label' 		=> 'محاسبه تعرفه به صورت متغیر بر اساس وزن',
										'default' 		=> 'no',
									),
						'calc_method' => array(
										'title' 		=> 'نحوه محاسبه',
										'type' 			=> 'textarea',
										'description' 	=> 'روش محاسبه: "وزن:قیمت," وزن بر اساس کیلوگرم و قیمت بر اساس قیمت تعیین شده ووکامرس',
										'default'		=> '0.5:6000,0.7:6700,1:7800,2:10000,3:13000,4:16000,5:19000,6:22000'
									)
						);
				}
			}
		}			
//=================================================================
//function for sefareshi shipping method
		//check if the class exist before
		if ( ! class_exists( 'WC_Post_Sefareshi_Shipping_Method' ) ) {
			//extending the class using woocommerce shipping class
			class WC_Post_Sefareshi_Shipping_Method extends WC_Shipping_Method {
				//constructing the class
				public function __construct() {
					$this->id = 'post_sefareshi_shipping_method'; 
					$this->method_title = 'پست سفارشی';
					$this->method_description = 'ارسال از طریق پست سفارشی'; 
					$this->init();
				}
				//initializing the needs of class
				function init() {
					// Load the settings API
					$this->init_form_fields(); 
					$this->init_settings(); 
					// Define user set variables
					$this->enabled 		  = $this->get_option( 'enabled' );
					$this->title 		  = $this->get_option( 'title' );
					$this->cost 		  = $this->get_option( 'cost' );
					// Save settings in admin if you have any defined
					add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
				}
				//the function of calculating the additional cost
				public function calculate_shipping( $package ) {
					 foreach ( $package['contents'] as $item_id => $item ) {
					  $product = $item['data'];
					  $weight = $product->get_weight();
				  }
				  if ($this->get_option('weight_enabled')=='no')
				  {
					   $calculated_cost=$this->get_option( 'cost' );
				  }
				 else 
				 { 
				  $weight_options=explode(",",$this->get_option('calc_method'));
				  $weight_Array2=array();
				  for ($i=0;$i<count($weight_options);$i++)
				  {
					  $weight_Array=explode(':',$weight_options[$i]);
					  $weight_Array2[]= array('weight' => $weight_Array[0], 'price' => $weight_Array[1]);
				  }
				  for ($i=0;$i<count($weight_options)-1;$i++)
				  {
					  if ($weight >= $weight_Array2[$i]['weight']&&$weight < $weight_Array2[$i+1]['weight'])
						  $calculated_cost= $weight_Array2[$i+1]['price'];
				  }	 
				 }	  
				  $rate = array(
					'id' => $this->id,
					'label' => $this->title,
					'cost' => $calculated_cost 
					);
					// Register the rate
					$this->add_rate( $rate );
				}
				//creating admin form options
				function init_form_fields() {
					global $woocommerce;

					$this->form_fields = array(
						'enabled' => array(
										'title' 		=> __( 'Enable/Disable', 'woocommerce' ),
										'type' 			=> 'checkbox',
										'label' 		=> __( 'Enable this shipping method', 'woocommerce' ),
										'default' 		=> 'no',
									),
						'title' => array(
										'title' 		=> __( 'Method Title', 'woocommerce' ),
										'type' 			=> 'text',
										'description' 	=> __( 'This controls the title which the user sees during checkout.', 'woocommerce' ),
										'default'		=> 'پست سفارشی'
									),
						'cost' => array(
										'title' 		=> 'هزینه ثابت',
										'type' 			=> 'text',
										'description' 	=> 'تعیین هزینه ثابت برای پست سفارشی',
										'default'		=> '0'
									),
						'weight_enabled' => array(
										'title' 		=> 'تعرفه متغیر',
										'type' 			=> 'checkbox',
										'label' 		=> 'محاسبه تعرفه به صورت متغیر بر اساس وزن',
										'default' 		=> 'no',
									),
						'calc_method' => array(
										'title' 		=> 'نحوه محاسبه',
										'type' 			=> 'textarea',
										'description' 	=> 'روش محاسبه: "وزن:قیمت," وزن بر اساس کیلوگرم و قیمت بر اساس قیمت تعیین شده ووکامرس',
										'default'		=> '0.5:6000,0.7:6700,1:7800,2:10000,3:13000,4:16000,5:19000,6:22000'
									)
						);
						
				}
			}
		}	
//=================================================================
//function for Tipax shipping method
		//check if the class exist before
		if ( ! class_exists( 'WC_Post_Tipax_Shipping_Method' ) ) {
			//extending the class using woocommerce shipping class
			class WC_Post_Tipax_Shipping_Method extends WC_Shipping_Method  {
				//constructing the class
				public function __construct() {
					$this->id = 'post_tipax_shipping_method'; 
					$this->method_title = 'تیپاکس';
					$this->method_description = 'ارسال از طریق تیپاکس';
					$this->init();
				}
				//initializing the needs of class
				function init() {
					// Load the settings API
					$this->init_form_fields(); 
					$this->init_settings(); 
					// Define user set variables
					$this->enabled 		  = $this->get_option( 'enabled' );
					$this->title 		  = $this->get_option( 'title' );
					$this->cost 		  = $this->get_option( 'cost' );
					$this->calc_method 	  = $this->get_option( 'calc_method' );
					// Save settings in admin if you have any defined
					add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
				} 
				//the function of calculating the additional cost
				public function calculate_shipping( $package ) {
					//getting the weight of each product
					 foreach ( $package['contents'] as $item_id => $item ) {
					  $product = $item['data'];
					  $weight = $product->get_weight();
				  }
				  //check if cost calculation is static 
				  if ($this->get_option('weight_enabled')=='no')
				  {
					   $calculated_cost=$this->get_option( 'cost' );
				  }
				  //check if cost calculation is variable
				 else if ($this->get_option('weight_enabled')=='yes')
				 { 
				  $weight_options=explode(",",$this->get_option('calc_method'));
				  $weight_Array2=array();
				  //getting the list of shipping prices per weight
				  for ($i=0;$i<count($weight_options);$i++)
				  {
					  $weight_Array=explode(':',$weight_options[$i]);
					  $weight_Array2[]= array('weight' => $weight_Array[0], 'price' => $weight_Array[1]);
				  }
				  //choosing the price from weight
				  for ($i=0;$i<count($weight_options)-1;$i++)
				  {
					  if ($weight >= $weight_Array2[$i]['weight']&&$weight < $weight_Array2[$i+1]['weight'])
						  $calculated_cost= $weight_Array2[$i+1]['price'];
				  }		 
				 }
				 //creating the array for adding cost
				  $rate = array(
					'id' => $this->id,
					'label' => $this->title,
					'cost' => $calculated_cost 
					);
					// adding the cost to the main cost
					$this->add_rate( $rate );
				}
				//creating admin form options
				function init_form_fields() {
					global $woocommerce;
					$this->form_fields = array(
						'enabled' => array(
										'title' 		=> __( 'Enable/Disable', 'woocommerce' ),
										'type' 			=> 'checkbox',
										'label' 		=> __( 'Enable this shipping method', 'woocommerce' ),
										'default' 		=> 'no',
									),
						'title' => array(
										'title' 		=> __( 'Method Title', 'woocommerce' ),
										'type' 			=> 'text',
										'description' 	=> __( 'This controls the title which the user sees during checkout.', 'woocommerce' ),
										'default'		=> 'تیپاکس'
									),
						'cost' => array(
										'title' 		=> 'هزینه ثابت',
										'type' 			=> 'text',
										'description' 	=> 'این گزینه برای مشخص کردن هزینه ثابت است',
										'default'		=> '0'
									),
						'weight_enabled' => array(
										'title' 		=> 'تعرفه متغیر',
										'type' 			=> 'checkbox',
										'label' 		=> 'محاسبه تعرفه به صورت متغیر بر اساس وزن',
										'default' 		=> 'no',
									),
						'calc_method' => array(
										'title' 		=> 'نحوه محاسبه',
										'type' 			=> 'textarea',
										'description' 	=> 'روش محاسبه: "وزن:قیمت," وزن بر اساس کیلوگرم و قیمت بر اساس قیمت تعیین شده ووکامرس',
										'default'		=> '0.5:6000,0.7:6700,1:7800,2:10000,3:13000,4:16000,5:19000,6:22000'
									)
						);
				}
			}
		}			
//=================================================================
//function for Bus shipping method
		//check if the class exist before
		if ( ! class_exists( 'WC_Post_Bus_Shipping_Method' ) ) {
			//extending the class using woocommerce shipping class
			class WC_Post_Bus_Shipping_Method extends WC_Shipping_Method  {
				//constructing the class
				public function __construct() {
					$this->id = 'post_bus_shipping_method'; 
					$this->method_title = 'ارسال با اتوبوس';
					$this->method_description = 'هزینه ارسال توسط اتوبوس';
					$this->init();
				}
				//initializing the needs of class
				function init() {
					// Load the settings API
					$this->init_form_fields(); 
					$this->init_settings(); 
					// Define user set variables
					$this->enabled 		  = $this->get_option( 'enabled' );
					$this->title 		  = $this->get_option( 'title' );
					$this->cost 		  = $this->get_option( 'cost' );
					$this->calc_method 	  = $this->get_option( 'calc_method' );
					// Save settings in admin if you have any defined
					add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
				} 
				//the function of calculating the additional cost
				public function calculate_shipping( $package ) {
					//getting the weight of each product
					 foreach ( $package['contents'] as $item_id => $item ) {
					  $product = $item['data'];
					  $weight = $product->get_weight();
				  }
				  //check if cost calculation is static 
				  if ($this->get_option('weight_enabled')=='no')
				  {
					   $calculated_cost=$this->get_option( 'cost' );
				  }
				  //check if cost calculation is variable
				 else if ($this->get_option('weight_enabled')=='yes')
				 { 
				  $weight_options=explode(",",$this->get_option('calc_method'));
				  $weight_Array2=array();
				  //getting the list of shipping prices per weight
				  for ($i=0;$i<count($weight_options);$i++)
				  {
					  $weight_Array=explode(':',$weight_options[$i]);
					  $weight_Array2[]= array('weight' => $weight_Array[0], 'price' => $weight_Array[1]);
				  }
				  //choosing the price from weight
				  for ($i=0;$i<count($weight_options)-1;$i++)
				  {
						if ($weight >= $weight_Array2[$i]['weight']&&$weight < $weight_Array2[$i+1]['weight'])
						$calculated_cost= $weight_Array2[$i+1]['price'];
				  }		 
				 }
				 //creating the array for adding cost
				  $rate = array(
					'id' => $this->id,
					'label' => $this->title,
					'cost' => $calculated_cost 
					);
					// adding the cost to the main cost
					$this->add_rate( $rate );
				}
				//creating admin form options
				function init_form_fields() {
					global $woocommerce;
					$this->form_fields = array(
						'enabled' => array(
										'title' 		=> __( 'Enable/Disable', 'woocommerce' ),
										'type' 			=> 'checkbox',
										'label' 		=> __( 'Enable this shipping method', 'woocommerce' ),
										'default' 		=> 'no',
									),
						'title' => array(
										'title' 		=> __( 'Method Title', 'woocommerce' ),
										'type' 			=> 'text',
										'description' 	=> __( 'This controls the title which the user sees during checkout.', 'woocommerce' ),
										'default'		=> 'ارسال با اتوبوس'
									),
						'cost' => array(
										'title' 		=> 'هزینه ثابت',
										'type' 			=> 'text',
										'description' 	=> 'مشخص نمودن هزینه ثابت برای ارسال با اتوبوس',
										'default'		=> '0'
									),
						'weight_enabled' => array(
										'title' 		=> 'تعرفه متغیر',
										'type' 			=> 'checkbox',
										'label' 		=> 'محاسبه تعرفه به صورت متغیر بر اساس وزن',
										'default' 		=> 'no',
									),
						'calc_method' => array(
										'title' 		=> 'نحوه محاسبه',
										'type' 			=> 'textarea',
										'description' 	=> 'روش محاسبه: "وزن:قیمت," وزن بر اساس کیلوگرم و قیمت بر اساس قیمت تعیین شده ووکامرس',
										'default'		=> '0.5:6000,0.7:6700,1:7800,2:10000,3:13000,4:16000,5:19000,6:22000'
									)
						);
				}
			}
		}			
	}
	add_action( 'woocommerce_shipping_init', 'post_shipping_method_init' );
	function add_post_shipping_method( $methods ) {
		$methods[0] = 'WC_Post_Pishtaz_Shipping_Method';
		$methods[1] = 'WC_Post_Sefareshi_Shipping_Method';
		$methods[2] = 'WC_Post_Tipax_Shipping_Method';
		$methods[3] = 'WC_Post_Bus_Shipping_Method';
		return $methods;
	}
	add_filter( 'woocommerce_shipping_methods', 'add_post_shipping_method' );
}

?>