<?php
/**
 * Plugin Name: مدیریت لایسنس ووکامرس
 * Plugin URI: http://tarhkadeh.ir
 * Description:  از طریق این پلاگین به راحتی میتوان ووکامرس را به یک فروشگاه لایسنس تبدیل کرد. لایسنس میتواند به صورت تکی و دسته ای وارد شود.
 * Version: 2.7
 * Author: Karaneshan
 * Author URI: http://karaneshan.ir
 */ 
 ini_set("display_errors", 0);
class SB_WC_Licences {

    public $orderID;

    public function __construct() {
        register_activation_hook(__FILE__, array($this, 'activate'));
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
        $this->addActions();
        add_action('woocommerce_order_status_changed', array($this, 'action_woocommerce_order_status_completed'));
        add_action('woocommerce_email_before_order_table', array($this, 'action_woocommerce_order_status_completed'));
    }

    public function action_woocommerce_order_status_completed($order_id) {
        if(is_object($order_id)){
            $order_id = $order_id->id;
        }
        $this->orderID = $order_id;
        $order = new WC_Order($order_id);
        
        $status = $order->get_status() ;
        $condition = false;
        $options = get_option('activation-codes-settings');
        foreach ($options as $key => $value) {
            if ($key == $status && $value == 1) {
                $condition = true;
                break;
            }
        }

        if ($condition) {
            $items = $order->get_items();

            foreach ($items as $key => $value) {
                if (empty($value['کد لایسنس ها'])) {
                    $this->action_woocommerce_add_order_item_meta($key, array('quantity' => $value['item_meta']['_qty'][0], 'product_id' => $value['item_meta']['_product_id'][0]));
                }
            }
        }
    }

    public function activate() {
        $plugin_settings = get_option('activation-codes-settings');
        if (false === $plugin_settings) {
            add_option('activation-codes-settings', array('completed' => 1, 'processing' => 1, 'pending' => 0));
        }

        global $wpdb;
        $query = array();
        $query[] = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}wc_product_licences(licence_id integer auto_increment primary key,
						product_id integer not null,
						licence_code varchar(100),
						licence_status varchar(100),
						activation_date datetime,
						creation_date datetime
					)";
        foreach ($query as $q) {
            $wpdb->query($q);
        }
    }

    public function deactivate() {
        
    }

    public function addActions() {
        if (is_admin()) {
            add_action('init', array($this, 'handleAdminRequests'));
            add_action('admin_init', array($this, 'action_add_metaboxes'));
            add_action('save_post', array($this, 'action_save_post'));
        } else {
            
        }
    }
	
	public function lmg_metabox_function(){
	add_meta_box( 'lmg', 'License Code Settings', array($this,'lmg_metabox'), 'product', 'side' ); 
	}
	
	public function lmg_metabox($post)
	{
	    wp_nonce_field( plugin_basename( __FILE__ ), 'wm_noncename' );
		?>
    <p>
		<label><strong><?php _e('License Code Per Quantity' , 'wgc'); ?></strong><?php _e('(Set the number of license code that will be given to the customer for each unit of this product ordered.)'); ?></label><br/>
		<input type="text" name="meta[license_unit]" value="<?php if (get_post_meta($post->ID, 'license_unit', true) == ""){ echo '1' ;}else{ print get_post_meta($post->ID, 'license_unit', true); }?>" size="100" style="padding:3px;width:150px;" />
		</p>
	
	<?php
    }
    public function save_lmg_metaboox($post_id)
	{
		if( !isset($_POST['post_type']) || $_POST['post_type'] != 'product' || !current_user_can('edit_post') )
			return false;
		if ( ! isset( $_POST['wm_noncename'] ) || ! wp_verify_nonce( $_POST['wm_noncename'], plugin_basename( __FILE__ ) ) )
			return;
		foreach($_POST['meta'] as $meta_key => $meta_value)
		{
			$_meta_value = addslashes(trim($meta_value));
			update_post_meta($post_id, $meta_key, $_meta_value);
		}
	}

    public function action_add_metaboxes() {
        add_meta_box('sb-wc-licences', __('لایسنس ها'), array($this, 'metabox_licences'), 'product', 'advanced');
    }

    public function metabox_licences($post) {
        global $wpdb;

        $product_id = $post->ID;
        $query = "SELECT * FROM {$wpdb->prefix}wc_product_licences WHERE product_id = $product_id AND licence_status = 'available'";
        $licences = $wpdb->get_results($query);
        require_once dirname(__FILE__) . '/metaboxes/licences.php';
    }

    public function handleAdminRequests() {
        global $wpdb;

        $task = isset($_REQUEST['task']) ? $_REQUEST['task'] : null;
        if (!$task)
            return false;
        if ($task == 'delete_licence') {
            global $wpdb;
            $post_id = (int) $_REQUEST['post'];
            $wpdb->delete($wpdb->prefix . 'wc_product_licences', array('licence_id' => (int) $_REQUEST['id']));
            $link = admin_url('post.php?post=' . $post_id . '&action=edit&message=4');
            wp_redirect($link);
            die();
        }
    }

    public function action_save_post($post_id) {
        global $wpdb;

        if ($_POST['post_type'] != 'product')
            return false;

        $product_id = $post_id;
        if (isset($_FILES['licences_file']) && $_FILES['licences_file']['size'] > 0) {
            $tmp_file = wp_tempnam($_FILES['licences_file']['name']);
            move_uploaded_file($_FILES['licences_file']['tmp_name'], $tmp_file);
            $fh = fopen($tmp_file, 'r');
            $contents = fread($fh, $_FILES['licences_file']['size']);
            fclose($fh);
            $licences = explode("\n", $contents);
            foreach ($licences as $l) {
                if (empty($l))
                    continue;
                $data = array('product_id' => $product_id, 'licence_code' => trim($l), 'licence_status' => 'available',
                    'creation_date' => date('Y-m-d H:i:s'));
                $wpdb->insert("{$wpdb->prefix}wc_product_licences", $data);
            }
        }
        if (isset($_POST['single_licence']) && !empty($_POST['single_licence'])) {
            $l = trim($_POST['single_licence']);
            $data = array('product_id' => $product_id,
                'licence_code' => $l,
                'licence_status' => 'available',
                'creation_date' => date('Y-m-d H:i:s'));
            $wpdb->insert("{$wpdb->prefix}wc_product_licences", $data);
        }
    }

    public function action_woocommerce_new_order($order_id) {
        $this->orderID = $order_id;
        global $woocommerce;
        $customer_orders = get_posts(array(
            'numberposts' => '1',
            'meta_key' => '_customer_user',
            'meta_value' => get_current_user_id(),
            'post_type' => 'shop_order',
            'post_status' => 'publish'
        ));

        foreach ($customer_orders as $customer_order) {
            $order = new WC_Order();

            $order->populate($customer_order);

            $status = $order->get_status() ;
            $item_count = $order->get_item_count();

            $condition = false;
            $options = get_option('activation-codes-settings');
            foreach ($options as $key => $value) {
                if ($key == $status && $value == 1) {
                    $condition = true;
                    break;
                }
            }

            if ($condition) {
                add_action('woocommerce_add_order_item_meta', array($this, 'action_woocommerce_add_order_item_meta'), 10, 2);
            }
        }
    }

    public function action_woocommerce_add_order_item_meta($item_id, $values) {
        global $wpdb,$post;

        $product_no = (int) $values['product_id'];
        $qty_no = (int) $values['quantity'] ;

        $query = $wpdb->get_results("SELECT licence_id, product_id, licence_code, licence_status FROM {$wpdb->prefix}wc_product_licences 
					WHERE product_id = $product_no 
					AND licence_code <> '' 
					AND licence_status = 'available' 
					LIMIT 0,$qty_no");

        $elements = array();
        $licenseString = "";
        $i = 1;
        foreach ($query as $query) {
            $elements[] = $query->licence_code;
            $license_id[] = $query->licence_id;

            $licenseString .= "<strong>Code#$i: </strong>" . $query->licence_code . "<br>";
            $i++;
        }

        $licence = $this->_getProductLicenseCode((int) $values['product_id'], (int) $values['quantity']);
        if (!$licence) {

            return false;
        }
        woocommerce_add_order_item_meta($item_id, 'License Code(s)', $licenseString);

        $this->_setLicenceCodeStatus(implode($license_id, ','), 'assigned');
    }

    protected function _getProductLicenseCode($product_id, $quantity) {
        if (empty($product_id))
            return false;

        global $wpdb;

        $queryCount = "SELECT count(licence_id) FROM {$wpdb->prefix}wc_product_licences 
				WHERE product_id = $product_id
				AND licence_code <> '' 
				AND licence_status = 'available'";
        $available_codes = $wpdb->get_var($queryCount);

        if ($available_codes <= 5) {
            $to = get_option('admin_email');
            $subject = 'License Codes Alert' . $date3;
            $message = 'با سلام, <br>تنها نعداد 5 عدد لایسنس از محصول شماره: ' . $product_id . ' باقی مانده است. لطفا لایسنس های بیشتری بیافزائید.. <br>با تشکر.';
            $headers = "MIME-Version: 1.0" . PHP_EOL;
            $headers .= "Content-Type: text/html; charset=UTF-8" . PHP_EOL;
           // wp_mail($to, $subject, $message, $headers, $attachments);
        }

        $order = new WC_Order($this->orderID);

        if ($available_codes < $quantity) {
            $to = $order->billing_email;
            $subject = 'License Codes out of stock' . $date3;
            $message = 'با سلام, <br>اط تاخیر به وجود آمده عذر میخواهیم, به زودی لایسنس درخواستی فرستاده خواهد شد. <br>با تشکر.';
            $headers = "MIME-Version: 1.0" . PHP_EOL;
            $headers .= "Content-Type: text/html; charset=UTF-8" . PHP_EOL;
            //wp_mail($to, $subject, $message, $headers, $attachments);

            return false;
        }

        $query = "SELECT licence_id, product_id, licence_code, licence_status FROM {$wpdb->prefix}wc_product_licences 
					WHERE product_id = $product_id
					AND licence_code <> '' 
					AND licence_status = 'available'
					ORDER BY creation_date ASC
					LIMIT 1";
        return $wpdb->get_row($query);
    }

    protected function _setLicenceCodeStatus($licence_id, $status) {
        global $wpdb;

        //$data = array('licence_status' => $status);

        $wpdb->query("UPDATE {$wpdb->prefix}wc_product_licences SET licence_status = '$status' WHERE licence_id in ($licence_id)");
        //$wpdb->update($wpdb->prefix . 'wc_product_licences', $data, array('licence_id' => $licence_id));
    }

}

$sb_wc_licences = new SB_WC_Licences();

// Plugin Settings Page

class MySettingsPage {

    /**
     * Holds the values to be used in the fields callbacks
     */
    private $options;

    /**
     * Start up
     */
    public function __construct() {
        add_action('admin_menu', array($this, 'add_plugin_page'));
        add_action('admin_init', array($this, 'page_init'));
    }

    /**
     * Add options page
     */
    public function add_plugin_page() {
        // This page will be under "Settings"
        add_options_page(
                'License Manager Settings', 'تنظیمات مدیریت لایسنس', 'manage_options', 'license-settings', array($this, 'create_admin_page')
        );
    }

    /**
     * Options page callback
     */
    public function create_admin_page() {
        // Set class property
        $this->options = get_option('activation-codes-settings');
        ?>
        <div class="wrap">
            <?php screen_icon(); ?>
            <h2>تنظیمات مدیریت لایسنس کارانشان</h2>           
            <form method="post" action="options.php">
                <?php
                // This prints out all hidden setting fields
                settings_fields('my_option_group');
                do_settings_sections('activation-codes-settings-admin');
                submit_button();
                ?>
            </form>
        </div>
        <?php
    }

    /**
     * Register and add settings
     */
    public function page_init() {
        register_setting(
                'my_option_group', // Option group
                'activation-codes-settings', // Option name
                array($this, 'sanitize') // Sanitize
        );

        add_settings_section(
                'setting_section_id', // ID
                'تنظیمات پلاگین مدیریت لایسنس', // Title
                array($this, 'print_section_info'), // Callback
                'activation-codes-settings-admin' // Page
        );

        add_settings_field(
                'completed', 'تمام شده', array($this, 'completed_callback'), 'activation-codes-settings-admin', 'setting_section_id'
        );

        add_settings_field(
                'processing', 'در حال پردازش', array($this, 'processing_callback'), 'activation-codes-settings-admin', 'setting_section_id'
        );

        add_settings_field(
                'pending', 'در حال انتظار', array($this, 'pending_callback'), 'activation-codes-settings-admin', 'setting_section_id'
        );
    }

    /**
     * Sanitize each setting field as needed
     *
     * @param array $input Contains all settings fields as array keys
     */
    public function sanitize($input) {
        $new_input = array();
        if (isset($input['completed']))
            $new_input['completed'] = absint($input['completed']);

        if (isset($input['processing']))
            $new_input['processing'] = absint($input['processing']);

        if (isset($input['pending']))
            $new_input['pending'] = absint($input['pending']);

        return $new_input;
    }

    /**
     * Print the Section text
     */
    public function print_section_info() {
        print 'لطفا وضعیت های سفارش مورد نیاز خود را انتخاب کنید.';
    }

    /**
     * Get the settings option array and print one of its values
     */
    public function completed_callback() {
        printf(
                '<input type="checkbox" value="1" id="id_number" name="activation-codes-settings[completed]" %s />', !empty($this->options['completed']) ? 'checked' : ''
        );
    }

    /**
     * Get the settings option array and print one of its values
     */
    public function processing_callback() {
        printf(
                '<input type="checkbox" value="1" id="id_number" name="activation-codes-settings[processing]" %s />', !empty($this->options['processing']) ? 'checked' : ''
        );
    }

    /**
     * Get the settings option array and print one of its values
     */
    public function pending_callback() {
        printf(
                '<input type="checkbox" value="1" id="id_number" name="activation-codes-settings[pending]" %s />', !empty($this->options['pending']) ? 'checked' : ''
        );
    }

}

if (is_admin())
    $my_settings_page = new MySettingsPage();
?>